<?php

namespace App\Controllers;

use App\Libraries\CIAuth;
use App\Libraries\PasswordGenerator;

use App\Models\PanelModel;
use App\Models\SidebarModel;

class SidebarController extends BaseController {
    
    public function __construct(){
        $panelModel = new PanelModel();
        $this->settings = $panelModel->getSettings();
        $this->details = new SidebarModel();
    }
    
     public function create(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        $password = PasswordGenerator::make(10,"d");
        
        $data = [
            'pageTitle' => 'Create Sidebar',
            'currentFile' => 'settings_web',
            'pageSave' => 'Create'
        ];
        $data['settings'] = $this->settings;
        return view('create_sidebar', $data);
    }
    
    public function edit($id = null){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        $dataDetails = $this->details->find($id);
        
        $data = [
            'pageTitle' => 'Edit Sidebar',
            'currentFile' => 'settings_web',
            'pageSave' => 'Save',
            'sidebar_id' => $dataDetails['id'],
            'row' => $dataDetails,
        ];
        $data['settings'] = $this->settings;
        return view('create_sidebar', $data);
    }
    
    public function createHandler(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        $editID = $this->request->getPost('sidebar_id');
        if(empty($editID)){
            
            $sidebar_type = trim($this->request->getPost('sidebar_type'));
            
            $sidebar_editor ='';
            $sidebar_html ='';
            $imageName ='';
            
            $sidebar_image_link = htmlentities(trim($this->request->getPost('sidebar_image_link')));
             
            if($sidebar_type=='visual_editor'){
                $sidebar_editor = addslashes(trim($this->request->getPost('sidebar_editor')));
            } else if($sidebar_type=='html_code'){
                $sidebar_html = addslashes(trim($this->request->getPost('sidebar_html')));
            } else {
                $imageName = $this->handleImageUpload();
            }
            
            $data = array( 
                'sidebar_title'  =>  $this->request->getPost('sidebar_title'),
                'sidebar_type'  =>  $sidebar_type,
                'sidebar_icon'  =>  $this->request->getPost('sidebar_icon'),
                'sidebar_editor'  =>  $sidebar_editor,
                'sidebar_html'  =>  $sidebar_html,
                'sidebar_image'  =>  $imageName,
                'sidebar_image_link'  =>  $sidebar_image_link
            ); 
            
            $this->details->insert($data);
            $message = array('message' => lang('Validation.added'),'class' => 'success');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('ns-admin/settings-web'));
            
        } else {
            
            $dataDetails = $this->details->find($editID);
            if($dataDetails){
                $sidebar_type = trim($this->request->getPost('sidebar_type'));
                
                $sidebar_editor ='';
                $sidebar_html ='';
                $imageName ='';
                
                $sidebar_image_link = htmlentities(trim($this->request->getPost('sidebar_image_link')));
                
                if($sidebar_type=='visual_editor'){
                    $sidebar_editor = addslashes(trim($this->request->getPost('sidebar_editor')));
                } else if($sidebar_type=='html_code'){
                    $sidebar_html = addslashes(trim($this->request->getPost('sidebar_html')));
                } else {
                    $imageName = $this->handleImageUpload($dataDetails['sidebar_image']);
                }
                
                $data = array( 
                    'sidebar_title'  =>  $this->request->getPost('sidebar_title'),
                    'sidebar_type'  =>  $sidebar_type,
                    'sidebar_icon'  =>  $this->request->getPost('sidebar_icon'),
                    'sidebar_editor'  =>  $sidebar_editor,
                    'sidebar_html'  =>  $sidebar_html,
                    'sidebar_image'  =>  $imageName,
                    'sidebar_image_link'  =>  $sidebar_image_link
                );
                
                $this->details->update($editID, $data);
                $message = array('message' => lang('Validation.updated'),'class' => 'success');
            } else {
                $message = array('message' => lang('Validation.updated_failed'),'class' => 'success');
            }
            session()->set('response_msg', $message);
            return redirect()->to(base_url('ns-admin/create-sidebar/'.$editID));
        }
    }
    
    public function delete($id = null){
        // Check if the user is authorized to perform the action
        if (!CIAuth::check()) {
            return $this->response->setJSON(['status' => 0, 'message' => 'Unauthorized']);
        }
        
        // Validate ID
        if (is_null($id) || !is_numeric($id)) {
            return $this->response->setJSON(['status' => 0, 'message' => 'Invalid ID']);
        }
        
        // Check if the record exists
        $record = $this->details->find($id);
        if (!$record) {
            return $this->response->setJSON(['status' => 0, 'message' => 'Record not found']);
        }
        
        try {
            // Attempt to delete the record
            if ($this->details->delete($id)) {
                session()->set('response_msg', ['message' => lang('Validation.deleted'), 'class' => 'success']);
                return $this->response->setJSON(['status' => 1, 'message' => 'Delete successful']);
            } else {
                return $this->response->setJSON(['status' => 0, 'message' => 'Failed to delete']);
            }
        } catch (\Exception $e) {
            // Log and handle potential errors during deletion
            log_message('error', 'Error deleting record: ' . $e->getMessage());
            return $this->response->setJSON(['status' => 0, 'message' => 'An error occurred while deleting']);
        }
    }
    
    public function status($id = null){
        // Ensure user is authenticated
        if (!CIAuth::check()) {
            return $this->response->setStatusCode(401)
                ->setJSON(['status' => 0, 'msg' => 'Unauthorized']);
        }
        
        // Validate ID
        if (is_null($id) || !is_numeric($id)) {
            return $this->response->setJSON(['status' => 0, 'msg' => 'Invalid ID']);
        }
        
        // Check if record exists
        $record = $this->details->find($id);
        if (!$record) {
            return $this->response->setJSON(['status' => 0, 'msg' => 'Record not found']);
        }
        
        // Ensure the request is a POST request
        if (!$this->request->is('post')) {
            return $this->response->setStatusCode(405)
                ->setJSON(['status' => 0, 'msg' => 'Method Not Allowed']);
        }
        
        try {
            $for_action = $this->request->getPost('for_action');
            $column = $this->request->getPost('column');
            
            // Update data
            $data = [$column => ($for_action === 'enable' ? '1' : '0')];
            $message = ($for_action === 'enable') ?  lang('Validation.enabled') : lang('Validation.disabled');
            
            $this->details->update($id, $data);
            
            return $this->response->setJSON([
                'status' => 1,
                'action' => $for_action,
                'msg' => $message,
                'class' => 'success'
            ]);
        } catch (\Exception $e) {
            return $this->response->setJSON([
                'status' => 0,
                'msg' => 'An error occurred while updating the record'
            ]);
        }
    }
    
    private function handleImageUpload($existingImage = '') {
        $file = $this->request->getFile('sidebar_image');
        if ($file->isValid() && !$file->hasMoved()) {
            if ($existingImage && file_exists("images/{$existingImage}")) {
                unlink("images/{$existingImage}");
            }
            $imageName = $file->getRandomName();
            $file->move('images/', $imageName);
            return $imageName;
        }
        return $existingImage;
    }
}